<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'es', version '4.3'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Comprendo y acepto el acuerdo sobre tratamiento de datos';
$string['activityoverview'] = 'Tiene próximas sesiones de BigBlueButton';
$string['bbbduetimeoverstartingtime'] = 'La hora de vencimiento para esta actividad debe ser mayor que la hora de inicio.';
$string['bbbdurationwarning'] = 'La duración máxima para esta sesión es de %duration% minutos.';
$string['bbbrecordallfromstartwarning'] = 'Esta sesión se está grabando desde el principio.';
$string['bbbrecordwarning'] = 'Esta sesión puede ser grabada.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Añadir una nueva sala de BigBlueButton';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Crear instancias de sesiones en vivo';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Crear instancias con grabación';
$string['bigbluebuttonbn:deleterecordings'] = 'Borrar grabaciones';
$string['bigbluebuttonbn:importrecordings'] = 'Importar grabaciones';
$string['bigbluebuttonbn:join'] = 'Unirse a una sala de BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'Gestionar grabaciones';
$string['bigbluebuttonbn:protectrecordings'] = 'Proteger grabaciones';
$string['bigbluebuttonbn:publishrecordings'] = 'Publicar grabaciones';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Desproteger grabaciones';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Cancelar la publicación de grabaciones';
$string['bigbluebuttonbn:view'] = 'Ver sala BigBlueButton';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Ver todos los formatos de grabación';
$string['bigbluebuttondisablednotification'] = 'El módulo de actividad de BigBlueButton se ha desactivado y actualmente no se puede acceder a ninguna actividad de curso existente de BigBlueButton. Antes de volver a habilitar este complemento, asegúrese de haber leído y aceptado el <a href="{$a}" target="_blank">acuerdo de tratamiento de datos</a> con Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'Módulo de actividad BigBlueButton desactivado.';
$string['cachedef_currentfetch'] = 'Datos para enumerar cualquier grabación recuperada recientemente.';
$string['cachedef_recordings'] = 'Grabación de metadatos';
$string['cachedef_serverinfo'] = 'Información de servidor remoto';
$string['cachedef_subplugins'] = 'Caché usada por rutinas de subplugin para acelerar cuando haga falta el proceso de descubrimiento del plugin.';
$string['cachedef_validatedurls'] = 'Caché de comprobaciones de URL validadas';
$string['calendarstarts'] = '{$a} está programado para';
$string['cannotperformaction'] = 'No se puede realizar la acción {$a} en esta grabación';
$string['completionattendance'] = 'Requiere asistencia (minutos)';
$string['completionattendance_desc'] = 'Entre y permanezca en la sala durante al menos {$a} minuto(s).';
$string['completionattendance_event_desc'] = 'El estudiante ha entrado a la sala y permaneció en la sesión durante al menos {$a} minuto(s)';
$string['completionattendancegroup'] = 'Requerir asistencia (minutos)';
$string['completionattendancegroup_help'] = 'Se requiere la asistencia a la reunión durante (n) minutos para completar.';
$string['completionengagement_desc'] = 'Participar en actividades durante la reunión.';
$string['completionengagementchats'] = 'Chats';
$string['completionengagementchats_desc'] = 'Participar en {$a} chat(s).';
$string['completionengagementchats_event_desc'] = 'Ha generado {$a} de chat(s)';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Cambiar su emoji {$a} vez / veces';
$string['completionengagementemojis_event_desc'] = 'Cambió su emoji {$a} vez / veces';
$string['completionengagementgroup'] = 'Requerir participación';
$string['completionengagementgroup_help'] = 'Se requiere la participación activa durante la sesión para completarla.';
$string['completionengagementpollvotes'] = 'Votaciones en la encuesta';
$string['completionengagementpollvotes_desc'] = 'Votar en las encuestas {$a} vez / veces.';
$string['completionengagementpollvotes_event_desc'] = 'Ha respondido {$a} voto(s) de la encuesta';
$string['completionengagementraisehand'] = 'Requerir levantar la mano';
$string['completionengagementraisehand_desc'] = 'Levantar la mano {$a} vez / veces.';
$string['completionengagementraisehand_event_desc'] = 'Ha levantado la mano {$a} veces';
$string['completionengagementtalks'] = 'Conversación';
$string['completionengagementtalks_desc'] = 'Hable {$a} vez(veces)';
$string['completionengagementtalks_event_desc'] = 'Ha generado {$a} conversación(es)';
$string['completionupdatestate'] = 'Estado de actualización completa';
$string['completionvalidatestate'] = 'Validar finalización';
$string['completionvalidatestatetriggered'] = 'Se ha activado la finalización de la validación.';
$string['completionview'] = 'Requerir vista';
$string['completionview_desc'] = 'Ver en la sala';
$string['completionview_event_desc'] = 'Se ha unido a la sala.';
$string['config_checksum_algorithm'] = 'Algoritmo de suma de comprobación del servidor BigBlueButton';
$string['config_checksum_algorithm_description'] = 'SHA1 es compatible con servidores más antiguos. SHA256 y SHA512 son más seguros. SHA512 cumple con FIPS 140-2.';
$string['config_default_messages'] = 'Mensajes por defecto';
$string['config_default_messages_description'] = 'Establecer mensajes por defecto para las actividades';
$string['config_disablecam_default'] = 'Desactivar la cámara web activada por defecto';
$string['config_disablecam_default_description'] = 'Si se activa, las cámaras web se desactivarán.';
$string['config_disablecam_editable'] = 'Desactivar cámara web se puede editar';
$string['config_disablecam_editable_description'] = 'Desactivar cámara web se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_disablemic_default'] = 'Desactivar micrófono activado por defecto';
$string['config_disablemic_default_description'] = 'Si está habilitado, los micrófonos se desactivarán.';
$string['config_disablemic_editable'] = 'Desactivar micrófono se puede editar';
$string['config_disablemic_editable_description'] = 'Desactivar micrófono se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_disablenote_default'] = 'Desactivar notas compartidas que por defecto están habilitadas';
$string['config_disablenote_default_description'] = 'Si está habilitado, las notas compartidas se desactivarán.';
$string['config_disablenote_editable'] = 'Desactivar notas compartidas se puede editar';
$string['config_disablenote_editable_description'] = 'Desactivar notas compartidas se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_disableprivatechat_default'] = 'Desactivar chat privado que por defecto está habilitado';
$string['config_disableprivatechat_default_description'] = 'Si está habilitado, el chat privado se desactivará.';
$string['config_disableprivatechat_editable'] = 'Desactivar chat privado se puede editar';
$string['config_disableprivatechat_editable_description'] = 'Desactivar chat privado se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_disablepublicchat_default'] = 'Desactivar chat público que por defecto está habilitado';
$string['config_disablepublicchat_default_description'] = 'Si está habilitado, el chat público se desactivará.';
$string['config_disablepublicchat_editable'] = 'Desactivar chat privado se puede editar';
$string['config_disablepublicchat_editable_description'] = 'Desactivar chat público se puede editar por defecto cuando se añade o actualiza la instancia.';
$string['config_dpa_note'] = 'Nota: Para cumplir con sus obligaciones de protección de datos, antes de habilitar este plugin, usted podría necesitar asegurarse de que ha leído y aceptado el acuerdo de procesamiento de datos. Para el servicio predeterminado gratuito de BigBlueButton, este es el <a href="{$a}" target="_blank">Acuerdo de procesamiento de datos con Blindside Networks</a>. Por favor consulte con sus propios profesionales de privacidad para asesoría.';
$string['config_experimental_features'] = 'Características experimentales';
$string['config_experimental_features_description'] = 'Configuración para características experimentales.';
$string['config_extended_capabilities'] = 'Compatibilidad extendida';
$string['config_extended_capabilities_description'] = 'Configuración para compatibilidad extendida cuando el servidor BigBlueButton lo ofrezca';
$string['config_general'] = 'Ajustes generales';
$string['config_general_description'] = 'Estos ajustes se aplican siempre.';
$string['config_guestaccess_enabled'] = 'Acceso de invitado externo';
$string['config_guestaccess_enabled_description'] = 'Permitir que usuarios sin cuenta en su sitio accededan a la sala.';
$string['config_hideuserlist_default'] = 'Ocultar la lista de usuarios activada por defecto';
$string['config_hideuserlist_default_description'] = 'Si está habilitado, la lista de usuarios de la sesión se ocultará.';
$string['config_hideuserlist_editable'] = 'El hecho de ocultad la lista de usuarios se puede modificar';
$string['config_hideuserlist_editable_description'] = 'Ocultar la lista de usuarios por defecto puede editarse cuando se añade o actualiza la instancia.';
$string['config_importrecordings'] = 'Importar grabaciones';
$string['config_importrecordings_description'] = 'Estos ajustes son específicos de esta funcionalidad.';
$string['config_importrecordings_enabled'] = 'Activar importación de grabaciones';
$string['config_importrecordings_enabled_description'] = 'Cuando esto y la función de grabación están habilitadas, es posible importar grabaciones de diferentes cursos a una actividad.';
$string['config_importrecordings_from_deleted_enabled'] = 'Activada importación de grabaciones de actividades eliminadas';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Cuando esto y la función de importación de grabaciones están habilitadas, es posible importar grabaciones de actividades que ya no están en el curso.';
$string['config_locksettings'] = 'Configuración de los ajustes de bloqueo';
$string['config_locksettings_description'] = 'Estos ajustes activan o desactivan las opciones de la interfaz de usuario para los ajustes de bloqueo, y también definen los valores por defecto para estas opciones.';
$string['config_meetingevents_enabled'] = 'Registrar eventos en vivo';
$string['config_meetingevents_enabled_description'] = 'Si se ativa, las sesiones en vivo se procesarán tras el fin de la sesión. Esta característica se requiere para la Finalización de Actividad y solamente funcionará si el servidor BigBlueButton es capaz de procesar scripts posteriores a eventos.';
$string['config_muteonstart'] = 'Silenciar al iniciar';
$string['config_muteonstart_default'] = 'Silenciar al inicio habilitado de forma predeterminada';
$string['config_muteonstart_default_description'] = 'Si está habilitado, la sesión se silenciará al inicio.';
$string['config_muteonstart_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones.';
$string['config_muteonstart_editable'] = 'Silenciar al inicio se puede editar';
$string['config_muteonstart_editable_description'] = 'Silenciar al inicio de forma predeterminada se puede editar cuando se agrega o actualiza la instancia.';
$string['config_participant'] = 'Participantes';
$string['config_participant_description'] = 'Esta configuración define el rol de forma predeterminada para los participantes.';
$string['config_participant_moderator_default'] = 'Moderador';
$string['config_participant_moderator_default_description'] = 'Esta regla se usa de forma predeterminada cuando se agrega una nueva sala.';
$string['config_poll_interval'] = 'Intervalo de la encuesta (en segundos) para actualizar el estado de la sala';
$string['config_poll_interval_description'] = 'El intervalo de la encuesta debe ser de al menos 2 segundos. Si es necesario, puede reducir la carga en el servidor remoto aumentando el intervalo.';
$string['config_presentation_default'] = 'Fichero de presentación predeterminado';
$string['config_presentation_default_description'] = 'Se puede proporcionar un fichero para su uso en todas las salas.';
$string['config_preuploadpresentation'] = 'Archivo de presentación';
$string['config_preuploadpresentation_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones. La función solo funciona si el servidor Moodle está accesible para BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Archivo de presentación en página de actividad';
$string['config_preuploadpresentation_editable_description'] = 'Opción en ajustes de actividad para cargar archivo de presentación a mostrar en la página de la actividad.';
$string['config_profile_picture_enabled'] = 'Mostrar imágenes del perfil';
$string['config_profile_picture_enabled_description'] = '¿Deben mostrarse las fotos de perfil de los participantes en las sesiones de BigBlueButton?';
$string['config_recording'] = 'Grabación';
$string['config_recording_all_from_start_default'] = 'Grabar todo desde el principio';
$string['config_recording_all_from_start_default_description'] = '¿Debería estar activado por defecto el ajuste "Empezar a grabar desde el principio" cuando se añade una nueva sala de BigBlueButton?';
$string['config_recording_all_from_start_editable'] = 'Grabar todo desde el principio se puede editar';
$string['config_recording_all_from_start_editable_description'] = '¿Debería poder editarse "Empezar a grabar desde el principio" en los ajustes de la actividad?';
$string['config_recording_default'] = 'Función de grabación habilitada de forma predeterminada';
$string['config_recording_default_description'] = '¿Debería estar activado por defecto el ajuste "La sesión se puede grabar" cuando se añade una nueva sala de BigBlueButton?';
$string['config_recording_description'] = 'Estos ajustes son específicos de esta funcionalidad';
$string['config_recording_editable'] = 'La función de grabación se puede editar';
$string['config_recording_editable_description'] = '¿Debería ser editable el ajuste "La sesión se puede grabar" en la configuración de la actividad?';
$string['config_recording_hide_button_default'] = 'Ocultar el botón de grabación';
$string['config_recording_hide_button_default_description'] = 'Si está marcado, el botón para grabar se ocultará';
$string['config_recording_hide_button_editable'] = 'Ocultar el botón de grabación se puede editar';
$string['config_recording_hide_button_editable_description'] = '¿Debería ser editable el ajuste "Ocultar el botón de grabación" en la configuración de la actividad?';
$string['config_recording_protect_editable'] = 'El estado de las grabaciones protegidas se puede editar';
$string['config_recording_protect_editable_description'] = 'Si está marcada, la interfaz incluye una opción para proteger/desproteger grabaciones.';
$string['config_recording_refresh_period'] = 'Período de actualización de la grabación (en segundos)';
$string['config_recording_refresh_period_description'] = '¿Con qué frecuencia se debe consultar el servidor BigBlueButton para actualizar la información remota para una grabación?';
$string['config_recording_safe_formats'] = 'Formatos de grabación visibles para todos';
$string['config_recording_safe_formats_description'] = 'Seleccione los formatos visibles para todo el mundo.
El resto de formatos sólo los pueden ver los profesores y otros usuarios con los permisos mod/bigbluebuttonbn:viewallrecordingformats y mod/bigbluebuttonbn:managerecordings.';
$string['config_recordingready_enabled'] = 'Enviar notificación de grabación disponible';
$string['config_recordingready_enabled_description'] = 'Si se activa, se enviará una notificación cuando esté disponible un enlace de grabación. Esta característica requiere que el servidor BigBlueButton tenga habilitado el script post_publish_recording_ready_callback.';
$string['config_recordings'] = 'Mostrar grabaciones';
$string['config_recordings_asc_sort'] = 'Ordenar las grabaciones en orden ascendente.';
$string['config_recordings_asc_sort_description'] = 'Las grabaciones se ordenan por fecha, o bien en orden cronológico o bien en cronológico inverso (la grabación más reciente primero).';
$string['config_recordings_deleted_default'] = 'Incluir grabaciones de actividades eliminadas habilitadas de forma predeterminada';
$string['config_recordings_deleted_default_description'] = 'Si está habilitada, la tabla de grabación incluirá las grabaciones pertenecientes a actividades eliminadas desde ese momento, si las hay.';
$string['config_recordings_deleted_editable'] = 'Incluir grabaciones de la función de actividades eliminadas se puede editar';
$string['config_recordings_deleted_editable_description'] = 'Incluir grabaciones de actividades eliminadas de forma predeterminada se puede editar cuando se agrega o actualiza la instancia.';
$string['config_recordings_description'] = 'Estos ajustes son específicos de la función';
$string['config_recordings_general'] = 'Mostrar configuración de grabación';
$string['config_recordings_general_description'] = 'Estos ajustes se utilizan solo cuando se muestran grabaciones';
$string['config_recordings_imported_default'] = 'Mostrar solo los enlaces importados habilitados de forma predeterminada';
$string['config_recordings_imported_default_description'] = 'Si está habilitada, la tabla de grabación incluirá solo los enlaces importados a las grabaciones.';
$string['config_recordings_imported_editable'] = 'Mostrar solo la función de enlaces importados se puede editar';
$string['config_recordings_imported_editable_description'] = 'Mostrar solo los enlaces importados de forma predeterminada se puede editar cuando se agrega o actualiza la instancia.';
$string['config_recordings_preview_default'] = 'La vista previa está habilitada de forma predeterminada';
$string['config_recordings_preview_default_description'] = 'Si está habilitado, la tabla incluye una vista previa de la presentación.';
$string['config_recordings_preview_editable'] = 'La función de vista previa se puede editar';
$string['config_recordings_preview_editable_description'] = 'La función de vista previa se puede editar cuando se agrega o actualiza la instancia.';
$string['config_scheduled'] = 'Sesiones programadas';
$string['config_scheduled_description'] = 'Estas configuraciones definen algunos de los comportamientos por defecto para las sesiones programadas.';
$string['config_scheduled_pre_opening'] = 'Accesible antes de la hora de apertura';
$string['config_scheduled_pre_opening_description'] = 'El tiempo en minutos para que la sesión sea accesible antes de que sea la hora de apertura programada.';
$string['config_server_url'] = 'URL del servidor BigBlueButton';
$string['config_server_url_description'] = 'Las credenciales por defecto son para un  <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank"> servicio gratuito de BigBlueButton de Moodle (abre en ventana nueva)</a> proporcionado por Blindside Networks con las siguientes restricciones:
<ol>
<li>La duración máxima de cada sesión es de 60 minutos</li>
<li>El número maximo de usuarios concurrentes por sesión es 25</li>
<li>Las grabaciones expiran tras siete (7) días y no son desacargables</li>
<li>Las cámaras web de estudiantes solamente son visibles para el moderador.</li>
</ol>';
$string['config_shared_secret'] = 'Clave secreta de BigBlueButton';
$string['config_shared_secret_description'] = 'La clave de seguridad de su servidor BigBlueButton. Esta clave por defecto es para un servidor BigBlueButton libre proporcionado por Blindside Networks.';
$string['config_uidelegation_enabled'] = 'La delegación de interfaz de usuario está habilitada';
$string['config_uidelegation_enabled_description'] = 'Esta configuración habilita o deshabilita la delegación de interfaz de usuario al servidor de BigBlueButton.';
$string['config_userlimit'] = 'Límite de usuarios';
$string['config_userlimit_default'] = 'Límite de usuarios habilitado de forma predeterminada';
$string['config_userlimit_default_description'] = 'Número de usuarios permitidos en una sesión de forma predeterminada cuando se agrega una nueva sala o conferencia. Si el número se establece en 0, no se establece ningún límite';
$string['config_userlimit_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones.';
$string['config_userlimit_editable'] = 'La función de límite de usuario se puede editar';
$string['config_userlimit_editable_description'] = 'El valor límite de usuario de forma predeterminada se puede editar cuando se agrega o actualiza la sala o la conferencia.';
$string['config_voicebridge'] = 'Puente de voz';
$string['config_voicebridge_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la interfaz de usuario y también definen valores predeterminados para estas opciones.';
$string['config_voicebridge_editable'] = 'El puente de voz de la conferencia se puede editar';
$string['config_voicebridge_editable_description'] = 'El número de puente de voz de conferencia se puede asignar permanentemente a una conferencia de sala. Cuando se asigna, el número no puede ser utilizado por ninguna otra sala o conferencia.';
$string['config_waitformoderator'] = 'Esperar al moderador';
$string['config_waitformoderator_cache_ttl'] = 'Esperar la caché TTL del moderador (segundos)';
$string['config_waitformoderator_cache_ttl_description'] = 'Para admitir una gran carga de clientes, este plugin utiliza un caché. Este parámetro define el tiempo que se mantendrá la caché antes de que se envíe la siguiente solicitud al servidor de BigBlueButton.';
$string['config_waitformoderator_default'] = 'Espera a que el moderador esté habilitado por defecto';
$string['config_waitformoderator_default_description'] = '¿Debería la función "Esperar al moderador" estar habilitada de forma predeterminada cuando se agrega una nueva sala BigBlueButton?';
$string['config_waitformoderator_description'] = 'Estos ajustes son específicos de la función';
$string['config_waitformoderator_editable'] = 'Se puede editar la función Esperar al moderador';
$string['config_waitformoderator_editable_description'] = '¿Debería "Esperar al moderador" ser editable en la configuración de actividad BigBlueButton?';
$string['config_waitformoderator_ping_interval'] = 'Esperar el ping del moderador (segundos)';
$string['config_waitformoderator_ping_interval_description'] = '¿Cada cuánto tiempo debería lanzarse un ping al servidor para comprobar si el moderador ha entrado en la sala?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN está utilizando config.php con una variable global que ha quedado obsoleta. Convierta el archivo, ya que no será compatible con versiones futuras.';
$string['config_warning_curl_not_installed'] = 'Esta función requiere que la extensión CURL para php  se encuentre instalada y habilitada. La configuración de estos parameteros será posible solo si esta condición se cumple.';
$string['config_welcome_default'] = 'Mensaje de bienvenida por defecto';
$string['config_welcome_default_description'] = 'El mensaje de bienvenida se muestra cuando los participantes entran en la sala. Si el campo se deja en blanco, se usará la cadena de lenguaje "mod_form_field_welcome_default".';
$string['config_welcome_editable'] = 'Los profesores pueden editar el mensaje de bienvenida predeterminado';
$string['config_welcome_editable_description'] = 'El mensaje de bienvenida puede editarse cuando se crea o se actualiza la instancia';
$string['dpainfonotsigned'] = 'Antes de habilitar esta extensión, debe confirmar que ha leído y aceptado el <a href="{$a}">acuerdo de procesamiento de datos de Blindside Networks</a>.';
$string['enablingbigbluebutton'] = 'Habilitar la actividad de BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'Para cumplir con sus obligaciones de protección de datos, antes de habilitar este plugin, usted podría necesitar asegurarse de que ha leído y aceptado el  <a href="{$a}" target="_blank">Acuerdo de Procesamiento de datos de Blindside Networks</a>. Por favor consulte con sus propios profesionales de privacidad para asesoría.';
$string['end_session_confirm'] = '¿Está seguro de que quiere finalizar la sesión?';
$string['end_session_confirm_title'] = '¿Terminar realmente la sesión?';
$string['end_session_notification'] = 'La sesión ha terminado.';
$string['ends_at'] = 'Finales';
$string['event_activity_created'] = 'Actividad creada';
$string['event_activity_deleted'] = 'Actividad eliminada';
$string['event_activity_updated'] = 'Actividad actualizada';
$string['event_live_session'] = 'Evento de sesión en vivo';
$string['event_meeting_created'] = 'Sala creada';
$string['event_meeting_ended'] = 'Se ha finalizado la sesión de forma deliberada';
$string['event_meeting_joined'] = 'Se ha unido a una sala';
$string['event_meeting_left'] = 'Ha abandonado la sesión';
$string['event_recording_deleted'] = 'Grabación borrada';
$string['event_recording_edited'] = 'Grabación editada';
$string['event_recording_imported'] = 'Grabación importada';
$string['event_recording_protected'] = 'Grabación protegida';
$string['event_recording_published'] = 'Grabación publicada';
$string['event_recording_unprotected'] = 'Grabación desprotegida';
$string['event_recording_unpublished'] = 'Grabación no publicada';
$string['event_recording_viewed'] = 'Grabación vista';
$string['event_unknown'] = 'Evento desconocido';
$string['general_error_cannot_create_meeting'] = 'No se puede crear la sesión.';
$string['general_error_cannot_get_recordings'] = 'No se pueden obtener grabaciones.';
$string['general_error_no_answer'] = 'Respuesta vacía. Verifique la URL del servidor BigBlueButton Y verifique si el servidor BigBlueButton se está ejecutando.';
$string['general_error_not_allowed_to_create_instances'] = 'El usuario no puede crear ningún tipo de instancias.';
$string['general_error_not_found'] = 'No se puede encontrar la actividad BigBlueButton con ID {$a}.';
$string['general_error_unable_connect'] = 'Incapaz de conectar. Por favor, compruebe la URL del servidor de BigBlueButton y que el servidor de BigBlueButton esté funcionando.
Detalles : {$a}';
$string['guest_invitation_full_message'] = 'Hola.
<p>Está invitado a una sesión de BigBlueButton <strong>{$a->name}</strong> en el curso {$a->course_fullname}.</p>
<p>Enlace: {$a->guestjoinurl}<br/>
<p>Contraseña: {$a->contraseña de invitado}</p>
<p>Si necesita ayuda, por favor, contacte con {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Hola.

Está invitado a una sesión de BigBlueButton {$a->name} en el curso {$a->course_fullname}.

Enlace: {$a->guestjoinurl}
Contraseña: {$a->contraseña de invitado}

Si necesita ayuda, por favor, contacte con {$a->sender}.';
$string['guest_invitation_subject'] = 'Invitación: {$a->name} sesión en {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Actividad no encontrada.';
$string['guestaccess_add'] = 'Añadir invitados/as';
$string['guestaccess_add_no_id'] = 'No se proporcionó ningún ID de instancia de BigBlueButton.';
$string['guestaccess_copy_link'] = 'Copiar enlace';
$string['guestaccess_copy_password'] = 'Copiar contraseña';
$string['guestaccess_emails'] = 'Correos electrónicos de invitados/as';
$string['guestaccess_emails_help'] = 'Una lista de direcciones de correo electrónico, separadas por comas.';
$string['guestaccess_emails_invalidemail'] = 'Correo electrónico no válido: {$a}';
$string['guestaccess_feature_disabled'] = 'Acceso de invitados/as deshabilitado.';
$string['guestaccess_invite_failure'] = 'Error {$a->errors} al invitar a {$a->emails}.';
$string['guestaccess_invite_success'] = 'Se enviará una invitación a {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Unirse a la reunión';
$string['guestaccess_meeting_invalid_password'] = 'Contraseña incorrecta.';
$string['guestaccess_meeting_link'] = 'Enlace de la reunión';
$string['guestaccess_meeting_not_started'] = 'La reunión aún no ha comenzado. Por favor, vuelva más tarde.';
$string['guestaccess_meeting_password'] = 'Contraseña de la reunión';
$string['guestaccess_password'] = 'Contraseña';
$string['guestaccess_title'] = 'Añadir invitados/as a esta reunión';
$string['guestaccess_username'] = 'Nombre de usuario/a invitado/a';
$string['index_confirm_end'] = '¿Quiere terminar la sesión?';
$string['index_disabled'] = 'deshabilitada';
$string['index_enabled'] = 'habilitada';
$string['index_ending'] = 'Finalizando la sesión... por favor espere';
$string['index_error_bbtn'] = 'El ID de BigBlueButton {$a} es incorrecto';
$string['index_error_checksum'] = 'Ha ocurrido en error en la suma de comprobación. Asegúrese de que ha introducido de forma correcta el contenido de "Secret".';
$string['index_error_forciblyended'] = 'Incapaz de unirse a esta sesión porque ha sido terminada manualmente.';
$string['index_error_noinstances'] = 'No hay instancias de BigBlueButton';
$string['index_error_unable_display'] = 'Incapaz de mostrar las sesiones. Por favor, compruebe la URL del servidor de BigBlueButton y compruebe si el servidor de BigBlueButton está funcionando.';
$string['index_heading'] = 'Salas BigBlueButton';
$string['index_heading_actions'] = 'Acciones';
$string['index_heading_group'] = 'Grupo';
$string['index_heading_moderator'] = 'Moderadores';
$string['index_heading_name'] = 'Sala';
$string['index_heading_recording'] = 'Grabación';
$string['index_heading_users'] = 'Usuarios';
$string['index_heading_viewer'] = 'Asistentes';
$string['indicator:cognitivedepth'] = 'BigBlueButtonBN cognitiva';
$string['indicator:cognitivedepth_help'] = 'Este indicador se basa en la profundidad cognitiva alcanzada por el alumno en una actividad de BigBlueButtonBN.';
$string['indicator:socialbreadth'] = 'BigBlueButtonBN social';
$string['indicator:socialbreadth_help'] = 'Este indicador se basa en la amplitud social alcanzada por el alumno en una actividad de BigBlueButtonBN.';
$string['instance_type_default'] = 'Sala con grabaciones';
$string['instance_type_recording_only'] = 'Solo grabaciones';
$string['instance_type_room_only'] = 'Sólo sala';
$string['instanceprofilewithoutrecordings'] = 'Este perfil de instancia no puede mostrar grabaciones';
$string['managebbbextplugins'] = 'Gestionar plugins de extensión de BigBlueButton';
$string['messageprovider:instance_updated'] = 'Sesión BigBlueButton actualizado';
$string['messageprovider:recording_ready'] = 'Grabación BigBlueButton disponible';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['mod_form_block_general'] = 'General';
$string['mod_form_block_guestaccess'] = 'Acceso de invitados/as';
$string['mod_form_block_participants'] = 'Rol asignado durante la sesión en vivo';
$string['mod_form_block_presentation'] = 'Presentación de contenido';
$string['mod_form_block_presentation_default'] = 'Contenido predeterminado de la presentación';
$string['mod_form_block_record'] = 'Ajustes de grabación.';
$string['mod_form_block_recordings'] = 'Vista de la grabación';
$string['mod_form_block_room'] = 'Ajustes de actividad/sala';
$string['mod_form_block_schedule'] = 'Programación de sesiones';
$string['mod_form_field_closingtime'] = 'Cerrado';
$string['mod_form_field_conference_name'] = 'Nombre de la sesión';
$string['mod_form_field_disablecam'] = 'Desactivar las cámaras web';
$string['mod_form_field_disablemic'] = 'Desactivar los micrófonos';
$string['mod_form_field_disablenote'] = 'Desactivar las notas compartidas';
$string['mod_form_field_disableprivatechat'] = 'Desactivar el chat privado';
$string['mod_form_field_disablepublicchat'] = 'Desactivar el chat público';
$string['mod_form_field_duration'] = 'Duración';
$string['mod_form_field_duration_help'] = 'Fijar la duración para una sesión establecerá el tiempo máximo para mantener activa una sesión antes de que termine la grabación';
$string['mod_form_field_guestallowed'] = 'Permitir el acceso de invitados/as';
$string['mod_form_field_hideuserlist'] = 'Ocultar la lista de usuarios';
$string['mod_form_field_instanceprofiles'] = 'Tipo de instancia';
$string['mod_form_field_instanceprofiles_help'] = 'Si se va a grabar una sesión, seleccione "Sala con grabaciones"; en caso contrario, "Sólo sala". Después de grabar una sesión, si no va a haber más sesiones, seleccione "Sólo grabaciones".';
$string['mod_form_field_intro'] = 'Descripción';
$string['mod_form_field_intro_help'] = 'Descripción corta para la sala o conferencia.';
$string['mod_form_field_mustapproveuser'] = 'Los invitados que se unan deben ser admitidos por un moderador';
$string['mod_form_field_muteonstart'] = 'Silenciar al comenzar';
$string['mod_form_field_name'] = 'Nombre de la sala virtual';
$string['mod_form_field_nosettings'] = 'No se puede editar ninguna configuración';
$string['mod_form_field_openingtime'] = 'Abierto';
$string['mod_form_field_participant_add'] = 'Agregar participante';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderador';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Observador';
$string['mod_form_field_participant_list'] = 'Participante';
$string['mod_form_field_participant_list_action_add'] = 'Agregar';
$string['mod_form_field_participant_list_action_remove'] = 'Eliminar';
$string['mod_form_field_participant_list_text_as'] = 'entra en la sesión como';
$string['mod_form_field_participant_list_type_all'] = 'Todos los usuarios inscritos';
$string['mod_form_field_participant_list_type_owner'] = 'Responsable';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Usuario';
$string['mod_form_field_record'] = 'La sesión puede ser grabada';
$string['mod_form_field_recordallfromstart'] = 'Grabar todo desde el principio';
$string['mod_form_field_recordhidebutton'] = 'Ocultar botón de grabación';
$string['mod_form_field_recordings_deleted'] = 'Incluir grabaciones de actividades eliminadas';
$string['mod_form_field_recordings_html'] = 'Mostrar la tabla en HTML plano';
$string['mod_form_field_recordings_imported'] = 'Mostrar solo enlaces importados';
$string['mod_form_field_recordings_preview'] = 'Mostrar vista previa de grabación';
$string['mod_form_field_room_name'] = 'Nombre de la sala';
$string['mod_form_field_userlimit'] = 'Límite de usuarios';
$string['mod_form_field_userlimit_help'] = 'Límite máximo de usuarios permitidos en una reunión. Si el límite está a 0 el número de usuarios será ilimitado.';
$string['mod_form_field_voicebridge'] = 'Puente de voz [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Error de formato. Debe introducir un número entre 1 y 9999.';
$string['mod_form_field_voicebridge_help'] = 'Número de la conferencia de voz que los participantes introducen para unirse a la conferencia de voz cuando se utiliza la marcación. Debe introducirse un número entre 1 y 9999. Si el valor es 0, el número estático de voicebridge será ignorado y un número aleatorio será generado por BigBlueButton. Un número 7 precederá a los cuatro dígitos tecleados';
$string['mod_form_field_voicebridge_notunique_error'] = 'No es un valor único. Este número ha sido usado por otra sala o conferencia.';
$string['mod_form_field_wait'] = 'Esperar al moderador';
$string['mod_form_field_wait_help'] = '¿Deben esperar los observadores hasta que un moderador entre a la sesión antes de entrar en la sala?';
$string['mod_form_field_welcome'] = 'Mensaje de bienvenida';
$string['mod_form_field_welcome_default'] = 'Bienvenido a <b>%%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'El mensaje de bienvenida se muestra cuando los participantes entran en la sala. Si el campo se deja en blanco, se muestra un mensaje por defecto configurado en la administración del sitio.';
$string['mod_form_locksettings'] = 'Ajustes de bloqueo';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButtonBN es un sistema de videoconferencia de código abierto diseñado para la enseñanza en línea que soporta compartir audio, vídeo, chat, presentaciones, pantalla, pizarra multi-usuario, grupos, encuentas y emojis en tiempo real

Usando BigBlueButton usted puede crear una sala para sesiones como clases en línea en directo, reuniones virtuales o colaboración en grupo con estudiantes a distancia. La sesión se puede grabar para reproducirla posteriormente.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Actividad de BigBlueButton';
$string['nosuchinstance'] = 'No existe tal instancia {$a->entity} con ID {$a->id}';
$string['notification_instance_created_intro'] = 'Se ha creado la sala BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_instance_created_small'] = 'Una nueva sala BigBlueButton nombrada {$a->name} fue creada.';
$string['notification_instance_created_subject'] = 'Se ha creado una nueva sala BigBlueButton';
$string['notification_instance_description'] = 'Descripción';
$string['notification_instance_end_date'] = 'Fecha de fin';
$string['notification_instance_name'] = 'Título';
$string['notification_instance_start_date'] = 'Fecha de inicio';
$string['notification_instance_updated_intro'] = 'La sala BigBlueButton <a href="{$a->link}">{$a->name}</a> se ha actualizado.';
$string['notification_instance_updated_small'] = 'Se actualizó la sesión BigBlueButton {$a->name}';
$string['notification_instance_updated_subject'] = 'Su sala BigBlueButton ha sido actualizada';
$string['notification_recording_ready_html'] = 'Ahora hay una grabación disponible para la sesión en la sala BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'Ahora hay una grabación disponible para la sesión en la sala BigBlueButton {$a->name}. Vaya a {$a->link} para acceder al enlace de grabación.';
$string['notification_recording_ready_small'] = 'Hay una grabación disponible para la sala BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'Grabación disponible';
$string['pluginadministration'] = 'Administración de BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Para crear y unirse a sesiones de BigBlueButton, los datos del usuario deben intercambiarse con el servidor.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'El nombre completo del usuario que accede al servidor de BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'El ID de usuario del usuario que accede al servidor de BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Configuración de la sesión BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Una lista de reglas que definen el rol que tendrán los usuarios en la reunión en vivo. Se puede almacenar una identificación de usuario ya que se pueden otorgar permisos por función o usuario.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Almacena eventos activados cuando se usa el complemento.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'El tipo de evento desencadenado por el usuario.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'El ID de reunión a la que el usuario tiene acceso.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Puede incluir información adicional relacionada con la reunión o la grabación afectada por el evento.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'La hora a la que se creó el registro.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'El ID de usuario del usuario que desencadenó el evento.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Almacena metadatos sobre grabaciones.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'El ID de usuario del usuario que cambió por última vez una grabación.';
$string['progress_createbigbluebuttonbn'] = 'Creación de la actividad BigBlueButton ({$a})';
$string['recordings_from_deleted_activities'] = 'Grabaciones de actividades eliminadas';
$string['recordingurlnotfound'] = 'La URL de grabación no es válida.';
$string['removedevents'] = 'Eventos eliminados';
$string['removedlogs'] = 'Registros personalizados eliminados';
$string['removedrecordings'] = 'Grabaciones eliminadas';
$string['removedtags'] = 'Etiquetas eliminadas';
$string['report_join_info'] = '{$a} sala(s)';
$string['report_play_recording_info'] = '{$a} grabación(es) reproducida(s)';
$string['report_room_view'] = 'visitado';
$string['resetevents'] = 'Eliminar eventos';
$string['resetlogs'] = 'Eliminar registros personalizados';
$string['resetlogs_help'] = 'Eliminar los registros provocará la pérdida de referencias a grabaciones';
$string['resetrecordings'] = 'Eliminar grabaciones';
$string['resetrecordings_help'] = 'Eliminar las grabaciones las hará inaccesibles desde cualquier lugar. ¡Esta acción no se puede deshacer!';
$string['resettags'] = 'Eliminar etiquetas';
$string['search:activity'] = 'BigBlueButtonBN - información de actividad';
$string['search:tags'] = 'BigBlueButtonBN - información de etiquetas';
$string['sendnotification'] = 'Enviar notificación';
$string['settings'] = 'Configuración de BigBlueButton';
$string['started_at'] = 'Empezado';
$string['starts_at'] = 'Empieza';
$string['subplugintype_bbbext'] = 'Extensión de actividad BigBlueButton';
$string['subplugintype_bbbext_plural'] = 'Extensiones de actividad BigBlueButton';
$string['taskname:check_dismissed_recordings'] = 'Buscar grabaciones que aún no se hayan encontrado';
$string['taskname:check_pending_recordings'] = 'Obtener grabaciones pendientes';
$string['userlimitreached'] = 'El número máximo de usuarios permitidos en la sala se ha alcanzado';
$string['view_conference_action_end'] = 'Fin de sesión';
$string['view_conference_action_join'] = 'Unirse a la sesión';
$string['view_error_action_not_completed'] = 'La acción no pudo ser completada';
$string['view_error_bigbluebutton'] = 'BigBlueButton respondió con errores. {$a}';
$string['view_error_create'] = 'El servidor BigBlueButton ha respondido con un mensaje de error, la sesión no pudo ser creada.';
$string['view_error_current_state_not_found'] = 'No se encontró el estado actual. Es posible que la grabación se haya eliminado o que el servidor de BigBlueButton no sea compatible con la acción realizada.';
$string['view_error_import_no_courses'] = 'No hay cursos para buscar grabaciones';
$string['view_error_import_no_recordings'] = 'No hay grabaciones en este curso para importar';
$string['view_error_invalid_session'] = 'La sesión ha caducado. Vuelve a la página principal de la actividad.';
$string['view_error_max_concurrent'] = 'El máximo número de sesiones concurrentes permitido ha sido alcanzado.';
$string['view_error_meeting_not_running'] = 'Algo salió mal, la reunión no se está ejecutando.';
$string['view_error_no_group'] = 'Aún no hay grupos configurados. Por favor, establezca los grupos antes de intentar unirse a una sesión.';
$string['view_error_no_group_student'] = 'Usted no ha sido asignado a ningún grupo. Por favor, contacte con su profesor.';
$string['view_error_no_group_teacher'] = 'No hay grupos. Por favor, cree los grupos.';
$string['view_error_unable_join'] = 'Incapaz de unirse a la sesión. Por favor compruebe la URL del servidor de BigBlueButton y compruebe que el servidor de BigBlueButton está en funcionamiento.';
$string['view_error_unable_join_student'] = 'Incapaz de conectarse al servidor de BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'Incapaz de conectarse al servidor de BigBlueButton. Por favor, póngase en contacto con el administrador.';
$string['view_error_url_missing_parameters'] = 'Faltan parámetros en esta URL';
$string['view_error_userlimit_reached'] = 'El número de usuarios permitido en una reunión ha sido alcanzado.';
$string['view_groups_nogroups_warning'] = 'La sala se configuró para usar grupos pero el curso no tiene grupos definidos.';
$string['view_groups_notenrolled_warning'] = 'La sala se configuró para usar grupos, pero no está inscripto en ninguno de ellos.';
$string['view_groups_selection'] = 'Seleccione el grupo al que desea unirse y confirme la acción';
$string['view_groups_selection_join'] = 'Ingresar';
$string['view_groups_selection_warning'] = 'Hay una sala de conferencia para cada grupo y usted tiene acceso a más de una. Asegúrese de seleccionar la sala correcta.';
$string['view_login_moderator'] = 'Accediendo como moderador...';
$string['view_login_viewer'] = 'Accediendo como asistente...';
$string['view_message_and'] = 'y';
$string['view_message_conference_has_ended'] = 'Esta conferencia ha terminado';
$string['view_message_conference_in_progress'] = 'Esta sesión está en proceso.';
$string['view_message_conference_not_started'] = 'Esta conferencia no ha comenzado todavía.';
$string['view_message_conference_room_ready'] = 'Esta sala de conferencia está lista. Puede unirse a la sesión ahora.';
$string['view_message_conference_user_limit_reached'] = 'Se ha alcanzado el límite de usuarios permitidos en una sesión.';
$string['view_message_conference_wait_for_moderator'] = 'Esperando a un moderador para unirse.';
$string['view_message_cron_disabled'] = 'Es posible que la lista de grabaciones no esté actualizada. Póngase en contacto con el administrador del sitio con la siguiente información: {$a}';
$string['view_message_finished'] = 'Esta actividad finalizó.';
$string['view_message_has_joined'] = 'se ha unido';
$string['view_message_have_joined'] = 'se han unido';
$string['view_message_hour'] = 'hora';
$string['view_message_hours'] = 'horas';
$string['view_message_importrecordings_disabled'] = 'La función para importar enlaces de grabación está deshabilitada en este servidor.';
$string['view_message_minute'] = 'minuto';
$string['view_message_minutes'] = 'minutos';
$string['view_message_moderator'] = 'Moderador';
$string['view_message_moderators'] = 'Moderadores';
$string['view_message_norecordings'] = 'No hay ninguna grabación que mostrar.';
$string['view_message_notavailableyet'] = 'Esta sesión aun no está disponible.';
$string['view_message_recordings_disabled'] = 'Las grabaciones se desactivaron en este servidor. No se pueden utilizar instancias de BigBlueButtonBN solo para grabaciones.';
$string['view_message_room_closed'] = 'Esta sala está cerrada.';
$string['view_message_room_open'] = 'Esta sala está abierta.';
$string['view_message_room_ready'] = 'Esta sala está lista.';
$string['view_message_session_for'] = 'la sesión para';
$string['view_message_session_has_user'] = 'Hay';
$string['view_message_session_has_users'] = 'Hay';
$string['view_message_session_no_users'] = 'No hay usuarios en esta sesión';
$string['view_message_session_running_for'] = 'Esta sesión ha estado activa por';
$string['view_message_session_started_at'] = 'Esta sesión comenzó a las';
$string['view_message_tab_close'] = 'Esta pestaña/ventana debe ser cerrada manualmente';
$string['view_message_times'] = 'tiempos';
$string['view_message_user'] = 'usuario';
$string['view_message_users'] = 'usuarios';
$string['view_message_viewer'] = 'Observador';
$string['view_message_viewers'] = 'Observadores';
$string['view_mobile_message_groups_not_supported'] = 'Esta instancia está habilitada para trabajar con grupos, pero la aplicación móvil no es compatible con esto aún. Por favor, acceda desde un navegador.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Excedió los 45 segundos en esta página, vuelva a cargar la página para unirse correctamente a la reunión.';
$string['view_noguests'] = 'El módulo BigBlueButton no está abierto para invitados';
$string['view_nojoin'] = 'Usted no tiene rol con permiso para unirse a esta sesión.';
$string['view_recording'] = 'grabación';
$string['view_recording_actionbar'] = 'Barra de herramienta';
$string['view_recording_activity'] = 'Actividad';
$string['view_recording_button_import'] = 'Importar enlaces de grabación';
$string['view_recording_button_return'] = 'Ir atrás';
$string['view_recording_course'] = 'Curso';
$string['view_recording_date'] = 'Fecha';
$string['view_recording_delete_confirmation'] = '¿Está seguro de eliminar {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si se elimina la grabación, esos enlaces también se eliminarán.';
$string['view_recording_delete_confirmation_warning_s'] = 'Esta grabación tiene un enlace {$a} asociado que se importó en un curso o actividad diferente. Si se elimina la grabación, ese enlace también se eliminará';
$string['view_recording_description'] = 'Descripción';
$string['view_recording_description_edithint'] = 'Puede agregar una descripción para ayudar a identificar la grabación.';
$string['view_recording_description_editlabel'] = 'Editar descripción';
$string['view_recording_duration'] = 'Duración';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'No se puede acceder a la URL de este formato de grabación.';
$string['view_recording_format_notes'] = 'Anotaciones';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentación';
$string['view_recording_format_screenshare'] = 'Compartir pantalla';
$string['view_recording_format_statistics'] = 'Estadísticas';
$string['view_recording_format_video'] = 'Vídeo';
$string['view_recording_import_confirmation'] = '¿Está seguro de querer importar esta grabación?';
$string['view_recording_length'] = 'Duración';
$string['view_recording_link'] = 'Enlace importado';
$string['view_recording_link_warning'] = 'Este es un enlace que apunta a una grabación que se creó en un curso o actividad diferente';
$string['view_recording_list_action_delete'] = 'Borrando';
$string['view_recording_list_action_edit'] = 'Actualizando';
$string['view_recording_list_action_play'] = 'Reproducir';
$string['view_recording_list_action_process'] = 'Procesando';
$string['view_recording_list_action_protect'] = 'Protegiendo';
$string['view_recording_list_action_publish'] = 'Publicando';
$string['view_recording_list_action_unprotect'] = 'Desprotegiendo';
$string['view_recording_list_action_unpublish'] = 'Despublicando';
$string['view_recording_list_action_update'] = 'Actualizando';
$string['view_recording_list_actionbar'] = 'Barra de herramientas';
$string['view_recording_list_actionbar_delete'] = 'Eliminar';
$string['view_recording_list_actionbar_edit'] = 'Editar';
$string['view_recording_list_actionbar_hide'] = 'Ocultar';
$string['view_recording_list_actionbar_import'] = 'Importar';
$string['view_recording_list_actionbar_protect'] = 'Hacer privado';
$string['view_recording_list_actionbar_publish'] = 'Publicar';
$string['view_recording_list_actionbar_show'] = 'Mostrar';
$string['view_recording_list_actionbar_unprotect'] = 'Hacer público';
$string['view_recording_list_actionbar_unpublish'] = 'Despublicar';
$string['view_recording_list_activity'] = 'Actividad';
$string['view_recording_list_course'] = 'Curso';
$string['view_recording_list_date'] = 'Fecha';
$string['view_recording_list_description'] = 'Descripción';
$string['view_recording_list_duration'] = 'Duración';
$string['view_recording_list_recording'] = 'Grabación';
$string['view_recording_meeting'] = 'Reunión';
$string['view_recording_modal_button'] = 'Aplicar';
$string['view_recording_modal_title'] = 'Coloque valores para grabación';
$string['view_recording_name'] = 'Nombre';
$string['view_recording_name_edithint'] = 'Puede agregar un nombre para ayudar a identificar la grabación.';
$string['view_recording_name_editlabel'] = 'Editar nombre';
$string['view_recording_playback'] = 'Reproducción';
$string['view_recording_preview'] = 'Vista preliminar';
$string['view_recording_preview_help'] = 'Colocar el cursor sobre una imagen para verla en tamaño completo';
$string['view_recording_protect_confirmation'] = '¿Está seguro de que quieres proteger esto {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si la grabación está protegida también afectará a los enlaces importados.';
$string['view_recording_protect_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace asociado que se importó a un curso o actividad diferente. Si la grabación está protegida, también afectará a los enlaces importados.';
$string['view_recording_publish_confirmation'] = '¿Seguro que quiere publicar este {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados a diferentes cursos o actividades. Si se publica la grabación, estos enlaces también se publicarán.';
$string['view_recording_publish_confirmation_warning_s'] = 'Esta grabación tiene asociado {$a} enlace que fue importado a un curso o actividad diferente. Si la grabación se publica, este enlace también se publicará.';
$string['view_recording_publish_link_deleted'] = 'Este enlace no se puede volver a publicar porque la grabación original no existe en el servidor BigBlueButton actual. El enlace debe eliminarse.';
$string['view_recording_publish_link_not_published'] = 'Este enlace no se puede volver a publicar porque la grabación original no está publicada.';
$string['view_recording_recording'] = 'Grabando';
$string['view_recording_select_course'] = 'Seleccione primero un curso en el menú desplegable';
$string['view_recording_tags'] = 'Etiquetas';
$string['view_recording_unprotect_confirmation'] = '¿Seguro que quiere desproteger este {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si la grabación está desprotegida también afectará a los enlaces importados.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Esta grabación tiene {$a} enlace asociado que se importó en un curso o actividad diferente. Si la grabación está desprotegida afectará también a los enlaces importados';
$string['view_recording_unprotect_link_deleted'] = 'Este enlace no puede desprotegerse porque la grabación original no existe en el servidor BigBlueButton actual. El enlace debe eliminarse.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Este enlace no se puede desproteger porque la grabación original está protegida.';
$string['view_recording_unpublish_confirmation'] = '¿Estás seguro de anular la publicación de {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Esta grabación tiene {$a} enlaces asociados que fueron importados en diferentes cursos o actividades. Si la grabación no se publica, esos enlaces también se cancelarán.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Esta grabación tiene un enlace {$a} asociado que se importó en un curso o actividad diferente. Si se anula la publicación de la grabación, ese enlace también se anulará.';
$string['view_recording_yui_first'] = 'Primero';
$string['view_recording_yui_go'] = 'Ir';
$string['view_recording_yui_last'] = 'Último';
$string['view_recording_yui_next'] = 'Siguiente';
$string['view_recording_yui_page'] = 'Página';
$string['view_recording_yui_prev'] = 'Anterior';
$string['view_recording_yui_rows'] = 'Filas';
$string['view_recording_yui_show_all'] = 'Mostrar todo';
$string['view_room'] = 'Ver sala';
$string['view_section_title_presentation'] = 'Archivo de presentación';
$string['view_section_title_recordings'] = 'Grabaciones';
$string['view_warning_default_server'] = 'Este servidor Moodle está utilizando el <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank"> servidor libre BigBlueButton para Moodle (se abre en ventana nueva)</a> provisto por Blindside Networks con las siguientes restricciones:
<ol>
<li>La duración máxima de cada sesión es de 60 minutos.</li>
<li>La cantidad máxima de usuarios concurrentes en cada sesión es 25.</li>
<li>Las grabaciones expiran tras siete (7) días y no se pueden descargar.</li>
<li>Las cámaras web de los estudiantes solamente son visibles para el moderador.</li>
</ol>';
$string['waitformoderator'] = 'Esperando que se una un moderador.';
